% ALPHA ENGINE DEFINITION
% Generated 17-Mar-2023 11:12:37

% SUGGESTED CITATION:
% Volvo 2.0L VEP LP Gen3 Miller Engine from 2020 Aachen Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Volvo 2.0L VEP LP Gen3 Miller Engine from 2020 Aachen Paper Octane Modified for Tier 3 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.969; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  12; 
engine.inertia_kgm2 =  0.11845; 
engine.bore_mm =  82; 
engine.stroke_mm =  93.2; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     105.23058321640147	;     127.02591433175641	;     135.23546419692013	;     141.39600186715839	;     149.63444609233829	;     149.84290164059479	;     152.41596158550948	;     157.33504667550062	;     166.18372853824440	;     174.58157546693411	;     176.43899602373850	;     180.86893738923322	;     183.45471796837379	;     471.66458813654032	;     491.07605487024716	;     549.99155937488956	;     577.49113734363402	;     604.99071531237860		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     160.17369700000000	;     202.35731999999999	;     220.11019141382744	;     234.08175214428439	;     253.45066501599314	;     253.94762865727918	;     259.60617047885859	;     269.43137969251023	;     274.21745247883769	;     281.02875725027991	;     282.42478616829789	;     292.91445202095832	;     299.17275294359285	;     299.62779200000000	;     293.67245700000001	;     263.39950399999998	;     225.77100342857142	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     604.99071531237860		]; 
engine.naturally_aspirated_torque_Nm = [	     141.01923732657389	    141.01923732657389		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     604.99071531237860	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -15.704266666666669	;    -38.116094740292709	;    -41.199337719599335		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     31.415926535897931	;     62.831853071795862	;     83.775804095727807	;     106.20967034509985	;     112.08419318274007	;     122.54197900906236	;     152.41596158550948	;     174.58157546693411	;     191.33516232198031	;     215.66960947439745	;     233.63289538967769	;     242.77955582791014	;     264.12294605477280	;     288.75621092819580	;     314.32954136874434	;     338.33846086761787	;     350.55746838131233	;     368.92327821761501	;     392.85989793879691	;     416.86976339586016	;     423.03375546301339	;     438.02561345615823	;     461.21501735004347	;     486.21786708971979	;     513.24842582863891	;     524.45015568972190	;     544.98666056968000	;     567.52998991095660	;     573.43289211203000	;     604.99071531237860		]; 
engine.fuel_map_torque_Nm = [	    -44.844870000000007	;    -21.172435000000004	;     2.5000000000000000	;     14.091190995454546	;     25.682381990909093	;     44.296348814285714	;     55.413391076260510	;     66.530433338235298	;     82.258064499999989	;     92.908188699999982	;     104.17627061851852	;     115.44435253703705	;     135.04962787500000	;     152.17121612500000	;     155.70719600000001	;     159.80148866666667	;     173.93887960526317	;     186.32754349999999	;     198.24005149999999	;     210.90039014285713	;     218.61042166666667	;     230.29067680952380	;     249.28942025000001	;     265.68789613888896	;     286.66023364814811	;     300.63470762407405	;     314.60918160000000		]; 
engine.fuel_map_gps = [
-0.0054146107893400077	 -0.047144640953166110	 -0.074038009369991858	 -0.089735271944147280	  -0.10451473101274324	  -0.10811994850289786	  -0.11437644639802121	  -0.12934173006348326	  -0.13669850585363463	  -0.14069593623331483	  -0.14408202606631226	  -0.14490178774666337	  -0.14501113126168272	  -0.14443339792433255	  -0.14210558297587331	  -0.13842381245414995	  -0.13456567564619218	  -0.13267795392810094	  -0.13001217663509543	  -0.12725206382957022	  -0.12576440430303445	  -0.12553348074080978	  -0.12515386032988493	  -0.12544434180206127	  -0.12702873853745714	  -0.12991633106825226	  -0.13126866583053917	  -0.13389660493129715	  -0.13694200518004265	  -0.13774570525315044	  -0.14208245428871272	;
  0.051698733138284492	  0.039534008800186517	  0.028615086464903409	  0.025258340776257923	  0.027929815487797795	  0.029272379779663231	  0.032033953992922311	  0.046061252584754506	  0.062660184314208861	  0.077344783610519441	   0.10156933632733969	   0.12114424886125871	   0.13139760464335223	   0.15609367688924530	   0.18632656756483501	   0.21963995991264754	   0.25262752842923797	   0.26986724237884901	   0.29623493080856422	   0.33155012137978479	   0.36778858104059786	   0.37713696274560143	   0.39992106706977043	   0.43539068673442610	   0.47418135705209130	   0.51694817753775313	   0.53477066111784688	   0.56750845917273052	   0.60335898065622218	   0.61272634135563919	   0.66262769586476700	;
  0.095428201035142060	   0.12130780947296801	   0.14168700567984432	   0.14418001372170708	   0.16430643607255724	   0.17078822377842781	   0.18296400018502362	   0.22718151402591102	   0.26767985553065521	   0.30057058128463454	   0.35115997364790441	   0.39006796795973969	   0.41015734316410546	   0.45782285523454103	   0.51490197915264135	   0.57673503936469006	   0.63752075895689986	   0.66936678640944858	   0.71827970079828385	   0.78488490516728582	   0.85590378347934737	   0.87457582870144968	   0.92049295080936444	   0.99355581969450601	    1.0750011809727320	    1.1654115822959030	    1.2028525308608282	    1.2712531557000288	    1.3456329861045744	    1.3650661491281721	    1.4686566582905829	;
  0.098707802805733463	   0.13949177615710592	   0.17805683144853071	   0.20176867355133490	   0.23382902658684776	   0.24331023675868563	   0.26080831088136747	   0.31991297640330429	   0.37079546602227392	   0.41154300434109448	   0.47340430384803989	   0.52137713033869026	   0.54609777403616699	   0.60463530524835951	   0.67460398052109749	   0.75108428545619355	   0.82593442648059967	   0.86462908903702151	   0.92355616545394603	    1.0035434904275973	    1.0903994653295985	    1.1136137928181014	    1.1712138828539016	    1.2659085124491578	    1.3723771500008750	    1.4847327236841898	    1.5308369714143184	    1.6151691800155290	    1.7086327146076243	    1.7332217934696370	    1.8656370138393241	;
  0.095544326666610599	   0.15268696745376048	   0.21030451957132407	   0.25120123903366831	   0.29954147527731834	   0.31324741796561406	   0.33814002703596596	   0.41363474386411164	   0.47414489328481035	   0.52208675782111336	   0.59435753606064745	   0.65168354971627329	   0.68107130592152698	   0.75074967530829173	   0.83290352929162681	   0.92468034830736279	    1.0146896077406851	    1.0599171171153572	    1.1279539373406693	    1.2212166474280197	    1.3239339502444516	    1.3512353009925442	    1.4185355737188965	    1.5376173978763261	    1.6736864615406017	    1.8041877396551100	    1.8575481036524053	    1.9569274664165095	    2.0711744130707244	    2.1015256621540317	    2.2646000211748607	;
  0.080805276832730241	   0.17220200640414896	   0.26516288043539288	   0.32936650391406080	   0.40087709677412880	   0.42011061742565248	   0.45460529608210554	   0.55569635046020216	   0.63100190718808069	   0.68986036870123679	   0.78064104693268577	   0.85163510488646332	   0.88877658088295430	   0.97797661380884249	    1.0859604906413989	    1.2019602730175545	    1.3112222755072558	    1.3666412576542994	    1.4509546907892268	    1.5700723890233315	    1.7043818868595182	    1.7400603738639076	    1.8282166283430323	    1.9759798669993147	    2.1401405073051811	    2.3063810230820643	    2.3754996000503965	    2.5045564250229471	    2.6555834185146550	    2.6957763668733352	    2.9084279861708953	;
  0.072943144828852169	   0.18637047386393260	   0.30089443177886177	   0.37841013667575368	   0.46252461263026223	   0.48468380706560615	   0.52420266004386307	   0.63814744231845988	   0.72443412324891876	   0.79194074628457056	   0.89479785765199560	   0.97507500905392008	    1.0171009236491912	    1.1185751381858022	    1.2414987347192792	    1.3720966293537398	    1.4957348563074586	    1.5590822843163685	    1.6557984348166392	    1.7912675020840128	    1.9393832685592973	    1.9779685065911055	    2.0724999438622964	    2.2249147568950178	    2.4002530596804355	    2.5953684582882879	    2.6772854661651770	    2.8292317784683449	    3.0007692971560891	    3.0459189151797368	    3.2887743456808738	;
  0.066889428768840242	   0.20213791857090765	   0.33776519661705146	   0.42829642823013941	   0.52506248171796577	   0.55030902009880744	   0.59524632782452724	   0.72389800919737768	   0.82203313928984068	   0.89884407987206483	    1.0152514548103633	    1.1054623978121871	    1.1525550938954081	    1.2660591611140097	    1.4031308401240910	    1.5482558719702684	    1.6867362247379494	    1.7590229228598273	    1.8697558549978610	    2.0200845838283210	    2.1785457960809489	    2.2198637580444043	    2.3211315874797456	    2.4829734554556766	    2.6710532665104401	    2.8887443511531017	    2.9806896936727409	    3.1517542258347251	    3.3464779619920577	    3.3973288427627448	    3.6683495531340440	;
  0.063399724095403842	   0.22775454687875760	   0.39170392739652221	   0.50028310737029136	   0.61562885260598554	   0.64566681859160879	   0.69907931578978011	   0.85173522578227356	   0.97026297991693067	    1.0627216489472642	    1.2015849748762999	    1.3078070381031399	    1.3626946727641294	    1.4930571778641304	    1.6483199846177041	    1.8137847948813428	    1.9735143369904102	    2.0567122403538525	    2.1837040005566748	    2.3534791667688761	    2.5297541902761025	    2.5759497873472323	    2.6895103728999237	    2.8722329889946079	    3.0817317674934528	    3.3239337489635936	    3.4275159813630873	    3.6214450899703885	    3.8409759001863288	    3.8980475377370363	    4.2020962945376956	;
  0.065183603793740982	   0.24783926846280679	   0.43010671809172468	   0.55107339962652491	   0.68006738171097225	   0.71378563346600399	   0.77378601947138337	   0.94543643752750017	    1.0778164103949586	    1.1805013084471925	    1.3339670500542427	    1.4507069092273153	    1.5108709727094340	    1.6533458634914702	    1.8222326739750849	    2.0018233629135351	    2.1751685717227689	    2.2649327578701826	    2.4015835518433071	    2.5842527448411876	    2.7745014932644558	    2.8243404843358682	    2.9468369805097918	    3.1435314473157345	    3.3672168775427469	    3.6249446205730909	    3.7354159127687820	    3.9421437315139416	    4.1744891362033192	    4.2354853840858100	    4.5624007673519404	;
  0.070730366320574514	   0.27177765778453983	   0.47286238287094179	   0.60702866593688454	   0.75093875586076719	   0.78865462714534340	   0.85581050112970103	    1.0481727672218097	    1.1949209110157522	    1.3081464807107495	    1.4766267443501127	    1.6042245154818247	    1.6698739488998171	    1.8250289326066469	    2.0085881743521745	    2.2034529921799701	    2.3909547647420610	    2.4878476425202622	    2.6352434437116012	    2.8323215466030067	    3.0374692135534715	    3.0910904652673237	    3.2227010745810070	    3.4327597574236042	    3.6708100227275255	    3.9449026042766651	    4.0628645070715583	    4.2836781932281296	    4.5312523426545575	    4.5962594187575148	    4.9448597641473491	;
  0.081085791119337294	   0.30347448572677987	   0.52215903308865774	   0.66619766254014223	   0.82365377118006788	   0.86513181918569937	   0.93903265887348875	    1.1514999867337639	    1.3128380531332364	    1.4367676897731416	    1.6201632676781388	    1.7582029118838738	    1.8290722051219992	    1.9962069389206480	    2.1936636104220293	    2.4040835331241568	    2.6066187482752157	    2.7111387004549505	    2.8701498226512867	    3.0827760477028674	    3.3020452205206352	    3.3591385134595648	    3.4990635163204904	    3.7219677875465997	    3.9754213004196859	    4.2678770284276961	    4.3936353585208314	    4.6295683863646930	    4.8932466826328369	    4.9621541354468901	    5.3295697176929355	;
   0.11780056097756408	   0.41459374880074418	   0.64049781970613173	   0.79474362276206656	   0.96523685834824535	    1.0103859137071192	    1.0910653001784978	    1.3319538936877389	    1.5170281619932191	    1.6588398232014681	    1.8672843256583951	    2.0228952149637687	    2.1025982565592849	    2.2902053246709153	    2.5116622018266916	    2.7480651541980277	    2.9766930906744786	    3.0952282216606681	    3.2756706889822373	    3.5156501278651131	    3.7601210395060365	    3.8233586406071374	    3.9779655459610446	    4.2251240900720370	    4.5118266213842073	    4.8430377364500252	    4.9837803529463613	    5.2451475249281998	    5.5323672842865568	    5.6070680512826048	    6.0034494654713306	;
   0.17665863778126012	   0.59603318280981965	   0.80143634114828843	   0.95322857507218683	    1.1230448096648804	    1.1686430322098287	    1.2515982962162280	    1.4968008413332841	    1.6947140676586787	    1.8486496197977929	    2.0757153595370217	    2.2461263998947785	    2.3335118450883328	    2.5392988112271655	    2.7821729423683874	    3.0415680853727061	    3.2924693526411182	    3.4223477264307456	    3.6200000651928148	    3.8832524471498506	    4.1541427285576367	    4.2246187966893523	    4.3972424860664061	    4.6719267263473787	    4.9849851171787529	    5.3431222261832385	    5.4944369646845184	    5.7747556252994583	    6.0855688601195412	    6.1670399433115675	    6.6030370175218227	;
   0.19042815858515524	   0.64215794237958279	   0.84029707641961093	   0.99027887075227283	    1.1586875532113901	    1.2041824139870665	    1.2871272675673615	    1.5320906930674094	    1.7315688453998554	    1.8880095397932859	    2.1189199275189234	    2.2923381099116540	    2.3812828845504712	    2.5907765001362946	    2.8380317126987920	    3.1020950407920549	    3.3575190907574304	    3.4897724353885144	    3.6910523490567932	    3.9590320241226493	    4.2351704973703699	    4.3070951353643236	    4.4833647558075569	    4.7640069119247164	    5.0828521958137420	    5.4468291334639574	    5.6006788532595424	    5.8857854477742109	    6.2022666559152650	    6.2852744514833967	    6.7299190553018722	;
   0.21613442199663482	   0.69803714096740532	   0.88658076785055062	    1.0340517672548410	    1.2006015277536630	    1.2460052895288185	    1.3286075041200760	    1.5731923009932376	    1.7743459351079602	    1.9336244636234294	    2.1689876836953648	    2.3458811822298014	    2.4366277356612560	    2.6504056397247440	    2.9027278158654992	    3.1721786090632755	    3.4328082274986453	    3.5677836101383784	    3.7731961248587691	    4.0467081100723554	    4.3289178128219588	    4.4025087418690552	    4.5829757553508053	    4.8704915257033736	    5.1961446956897195	    5.5669927027570392	    5.7238539232151311	    6.0146557247472723	    6.3378326085044208	    6.4226457669401800	    6.8773838964090785	;
   0.36920698341683650	   0.92239028588007299	    1.0666040076896690	    1.2013310932868173	    1.3583765735159676	    1.4021159768425986	    1.4795930057233377	    1.7200576917780099	    1.9260202480201460	    2.0922946837815091	    2.3430009071974811	    2.5317939466019461	    2.6287047305540652	    2.8571396537459339	    3.1268026270363585	    3.4144378267636921	    3.6921686057456675	    3.8358636860025088	    4.0545132411979239	    4.3467570178736255	    4.6504573213635343	    4.7297605181358264	    4.9243699425103502	    5.2348027171126406	    5.5857773769126835	    5.9842017596501540	    6.1529512031826856	    6.4663822880468178	    6.8152921909421309	    6.9069038952856960	    7.3984648248846501	;
   0.54841964730417569	    1.1600359004294261	    1.2543156576125527	    1.3782766255656738	    1.5301596732943401	    1.5711449268162430	    1.6452190678193566	    1.8727809879303010	    2.0762241628736051	    2.2413710304810279	    2.4995551581756756	    2.6986060099490818	    2.8008209711495331	    3.0417671615625168	    3.3258423640530212	    3.6283985607319664	    3.9204808031115301	    4.0715758230324663	    4.3014832287716471	    4.6090611020955983	    4.9299645285797302	    5.0139045427988860	    5.2200163026955000	    5.5497718814468637	    5.9255952956265983	    6.3559245885098212	    6.5382382631403795	    6.8763829550812563	    7.2519551508648892	    7.3505682106694552	    7.8797812184126821	;
   0.75184378334111757	    1.4129010582909600	    1.4502254003428159	    1.5633719255442788	    1.7103984857267336	    1.7497718676728116	    1.8234205121128610	    2.0385680294399027	    2.2342079340109176	    2.3983158448933430	    2.6592580331400764	    2.8639111210974448	    2.9707436860004979	    3.2229468271991708	    3.5194726326777466	    3.8355665230591476	    4.1421931459214330	    4.3009334367379619	    4.5423702005136262	    4.8649747152112592	    5.2013851287571562	    5.2893892063310464	    5.5055076963556626	    5.8519322811441992	    6.2514359419413710	    6.7166840304688780	    6.9140069211212101	    7.2798206728382642	    7.6847465516926503	    7.7909704268373483	    8.3602930640567568	;
   0.98625242837935700	    1.6930946782337566	    1.6620189410824124	    1.7622420711920781	    1.9026663945000835	    1.9423615455472154	    2.0169178222812283	    2.2314435400062438	    2.4196642975672482	    2.5862785182631125	    2.8482157212350017	    3.0546710890139024	    3.1613505449127519	    3.4187772009325195	    3.7267086853414524	    4.0573872346953719	    4.3808935688023212	    4.5487369918046179	    4.8038103575254842	    5.1434788918429017	    5.4969913501167742	    5.5894752266674281	    5.8166321974980422	    6.1814171153190705	    6.6047466239775652	    7.1074711728471707	    7.3214912977393887	    7.7186400482170887	    8.1560437072476368	    8.2705993676496465	    8.8830620160397160	;
    1.1314319031772291	    1.8632140459411319	    1.7887628127510025	    1.8812613318660834	    2.0171578024982622	    2.0568313140876167	    2.1321658157894383	    2.3563352275740415	    2.5465252297172940	    2.7105650291324639	    2.9721160620881699	    3.1775246967738671	    3.2848760208546186	    3.5416015794554676	    3.8548340397654690	    4.1934794981218309	    4.5266776792572436	    4.7002846633286310	    4.9647513717177238	    5.3161607704362179	    5.6813131980758964	    5.7768420529382016	    6.0114849553441232	    6.3883415318274874	    6.8258398881941238	    7.3509594022396314	    7.5748767632420453	    7.9901560157658160	    8.4461418357813738	    8.5654027480744173	    9.2017877893475806	;
    1.3414371260837019	    2.1151232742299757	    1.9754684473035975	    2.0576818647283743	    2.1895674531283755	    2.2305819265834730	    2.3082916620604985	    2.5475956414737646	    2.7468349718739908	    2.9095081730360750	    3.1682540649582815	    3.3734543397258836	    3.4811954440242627	    3.7384926126249307	    4.0559386213908590	    4.4127551679397206	    4.7526916529477807	    4.9319885197302025	    5.2100837762329899	    5.5816363123218764	    5.9668082978800410	    6.0675321914376701	    6.3149009372041212	    6.7121963318271698	    7.1739453798468888	    7.7294230321917929	    7.9669622759257450	    8.4077487759572964	    8.8877537614410898	    9.0131219061518237	    9.6811860713035429	;
    1.6186044095584793	    2.4747985090201001	    2.2527421412350894	    2.3306889981825698	    2.4756357308985466	    2.5217087861069438	    2.6082375578949217	    2.8753485837279076	    3.0861200221824023	    3.2522028759241937	    3.5071288929382951	    3.7121285399507311	    3.8207230454430521	    4.0809984622058790	    4.3959292149215967	    4.7763434236841942	    5.1426902488054482	    5.3309019422865873	    5.6273387116823415	    6.0316553302903122	    6.4560353696133337	    6.5672929129271109	    6.8407673421110173	    7.2797083934053672	    7.7841045752208675	    8.3734186702880340	    8.6236685075529227	    9.0871319648291067	    9.5931906058095340	    9.7253146035472025	    10.429099955823764	;
    1.8326374209736662	    2.7751772028892012	    2.4790729624263945	    2.5480272846975489	    2.7109366126696224	    2.7629468533742449	    2.8625045494714634	    3.1615101877565421	    3.3696416123924746	    3.5308498247471154	    3.7909081130879621	    4.0051009550271059	    4.1163563599948043	    4.3758834971519445	    4.7065105020274771	    5.0942327032026844	    5.4850107997995847	    5.6909236161127206	    6.0075818542292501	    6.4403665864613702	    6.8998757182682402	    7.0203824604598886	    7.3164967335119870	    7.7895176788240921	    8.3238489741428996	    8.9277370645463581	    9.1819839678697655	    9.6517906018261588	    10.168860788798879	    10.304173043525779	    11.027013920943926	;
    2.1034067415089899	    3.1626356839710090	    2.7640173706651252	    2.8158350772831278	    2.9763009224015886	    3.0292702179845965	    3.1317370616394142	    3.4417910598497121	    3.6607882773584062	    3.8361758014394800	    4.1137200907246037	    4.3472613014655739	    4.4685982969365652	    4.7511535118878276	    5.1114076246426770	    5.5311842025468998	    5.9564265698226002	    6.1798191003777685	    6.5240460762430059	    6.9942604203448369	    7.4905890956283310	    7.6201607690225792	    7.9377671134701648	    8.4401830865832821	    8.9972550366732893	    9.6136886064064626	    9.8713797490591766	    10.346127921885875	    10.870113311687501	    11.007450254953985	    11.742585092594831	;
    2.2921390440542369	    3.4277279615911098	    2.9523643422311183	    2.9895582390173905	    3.1457978572881862	    3.1988618227628702	    3.3023938299197764	    3.6190995608479843	    3.8504132343083208	    4.0374408926698360	    4.3314376937414885	    4.5783668021600041	    4.7065367500470368	    5.0043827419458449	    5.3838497675143904	    5.8289930302010484	    6.2827818939598155	    6.5202711920475913	    6.8845451342683655	    7.3769824739876508	    7.8916818213314173	    8.0256408285985152	    8.3535279744724686	    8.8697971865155072	    9.4382558227443365	    10.063117212233495	    10.323622959673383	    10.802829164907457	    11.330951618440276	    11.469348822272558	    12.210026467895309	;
    2.4897469108081602	    3.7017409657820566	    3.1429418759999272	    3.1638871503756700	    3.3157054706155304	    3.3690614356831610	    3.4741429583656136	    3.8004609438557191	    4.0431888924960573	    4.2405552528149064	    4.5502590519607979	    4.8102886921795767	    4.9451255937078500	    5.2578411514791803	    5.6573018064809402	    6.1292439180241161	    6.6128147435201621	    6.8643372573755030	    7.2481796668215326	    7.7623396664260236	    8.2943051733115674	    8.4322925020452093	    8.7695121952363397	    9.2981200625053155	    9.8770479691675614	    10.510543909305603	    10.774054426795523	    11.258105339088306	    11.790562607232758	    11.930036652923912	    12.676042688509163	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('LMDV_TIER_3_REG');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
